//-------------------------------------------------------------------------------
//-------------------------------------------------------------------------------
//
//	File:
//		NxPNG Auto.cpp
//
//	Description:
//		Export paletted PNGs from Photoshop via a batch process of operations
//
//-------------------------------------------------------------------------------
//-------------------------------------------------------------------------------
//	Includes
//-------------------------------------------------------------------------------
#define OLDP2C 1

#include "NxPNG Auto.h"
#include "ADMBasic.h"
#include "ADMItem.h"
#include "SPFiles.h"
#include <process.h>
//-------------------------------------------------------------------------------
//	Classes
//-------------------------------------------------------------------------------
// This is based on the AutomationPlugin class found in AutomationPlugin.h. 
// The PluginMain routine is now in AutomationMain.cpp and this class gets 
// created and deleted depending on the messages.
class AutoNxPNGPlugin : public AutomationPlugin {
private:

	// a message from Photoshop menu or action
	virtual SPErr DoIt(PSActionsPlugInMessage *message);
	virtual ASErr UnloadPlugin(SPInterfaceMessage *message);

	// don't create these classes, there should be only one
	AutoNxPNGPlugin(); // don't write this one
	AutoNxPNGPlugin(AutoNxPNGPlugin &rhs); // don't write this one

public:
	// These are protected, only the Instance routine can call them.
	AutoNxPNGPlugin(SPPluginRef pluginRef);
	virtual ~AutoNxPNGPlugin();
};


//-------------------------------------------------------------------------------
//	Globals
//-------------------------------------------------------------------------------
// the basic suite, needed for the new and delete operators
SPBasicSuite *sSPBasic = NULL;

// global suite pointers needed by the PIUActionUtils routines
PSActionDescriptorProcs *sPSActionDescriptor = NULL;
PSActionControlProcs *sPSActionControl = NULL;
PSActionReferenceProcs *sPSActionReference = NULL;
PSActionListProcs *sPSActionList = NULL;
ADMBasicSuite			*sADMBasic = NULL;
ADMItemSuite			*sADMItem = NULL;
PSHandleSuite1 *sPSHandle = NULL;

// global suite pointers name and version information
// make sure this is global and the AutomationPlugin base class
// will acquire and release these as needed
ImportSuite gImportSuites[] =
{
	kPSActionDescriptorSuite, kPSActionDescriptorSuiteVersion, (void **)&sPSActionDescriptor,
	kPSActionListSuite, kPSActionListSuiteVersion, (void **)&sPSActionList,
	kPSActionReferenceSuite, kPSActionReferenceSuiteVersion, (void **)&sPSActionReference,
	kPSActionControlSuite, kPSActionControlSuitePrevVersion, (void **)&sPSActionControl,
	kADMBasicSuite, kADMBasicSuiteVersion, (void **)&sADMBasic,
	kADMItemSuite, kADMItemSuiteVersion, (void **)&sADMItem,
	kPSHandleSuite, kPSHandleSuiteVersion1, (void **)&sPSHandle,

	NULL, 0, NULL // this has to be last
};

//-------------------------------------------------------------------------------
//
//	ParseFilenameToDisplay.
//
//	Takes a SPPlatformFileSpec and returns the shortened filename.
//
//-------------------------------------------------------------------------------
static SPErr ParseFilenameToDisplay
	(
	/* IN */	const SPPlatformFileSpecification fileSpec,
	/* OUT */	char displayString[_MAX_PATH]
	)
	{
	SPErr error = kSPNoError;
	
	#ifdef __PIMac__
	
		strncpy(displayString, (const char*)&fileSpec.name[1], fileSpec.name[0]);
		displayString[fileSpec.name[0]] = 0;
	
	#elif defined(__PIWin__)
	
		_splitpath
			(
			fileSpec.path,
			NULL,			// drive,
			NULL,			// directory,
			displayString,	// filename
			NULL			// extension
			);
	#endif
	
	return error;
	
	} // ParseFilenameToDisplay

SPErr PlayeventSaveAs( char* file_path )
{
	Handle aliasValue = NULL;
	PIActionDescriptor desc00000018 = NULL;
	PIActionDescriptor desc00000020 = NULL;

	PIActionDescriptor result = NULL;
	SPErr error = kSPNoError;
     

	error = sPSActionDescriptor->Make(&desc00000018);
	if (error) goto returnError;
	
	error = sPSActionDescriptor->Make(&desc00000020);
	if (error) goto returnError;

	error = sPSActionDescriptor->PutEnumerated(desc00000020, keyPNGInterlaceType, typePNGInterlaceType, enumPNGInterlaceNone);
	if (error) goto returnError;

	error = sPSActionDescriptor->PutEnumerated(desc00000020, keyPNGFilter, typePNGFilter, enumPNGFilterAdaptive);
	if (error) goto returnError;

	error = sPSActionDescriptor->PutObject(desc00000018, keyAs, classPNGFormat, desc00000020);
	if (error) goto returnError;

	FullPathToAlias( file_path, aliasValue);
	error = sPSActionDescriptor->PutAlias(desc00000018, keyIn, aliasValue);
	if (error) goto returnError;

	error = sPSActionDescriptor->PutBoolean(desc00000018, keyCopy, true);
	if (error) goto returnError;

	error = sPSActionControl->Play(&result, eventSave, desc00000018, plugInDialogSilent);
	if (error) goto returnError;

returnError:
	if (result != NULL) sPSActionDescriptor->Free(result);
	if (desc00000018 != NULL) sPSActionDescriptor->Free(desc00000018);
	if (desc00000020 != NULL) sPSActionDescriptor->Free(desc00000020);
	if (aliasValue != NULL) sPSHandle->Dispose(aliasValue);
		return error;
}

SPErr PlayeventOpen( char* file_path )
{
	Handle aliasValue = NULL;
	PIActionDescriptor desc00000028 = NULL;
	PIActionDescriptor desc00000030 = NULL;
	PIActionDescriptor desc00000038 = NULL;

	PIActionDescriptor result = NULL;
	DescriptorTypeID runtimeObjID;
	SPErr error = kSPNoError;   

	error = sPSActionDescriptor->Make(&desc00000028);
	if (error) goto returnError;
	
	FullPathToAlias( file_path, aliasValue );
	error = sPSActionDescriptor->PutAlias(desc00000028, keyNull, aliasValue);
	if (error) goto returnError;
	
	error = sPSActionDescriptor->Make(&desc00000030);
	if (error) goto returnError;

	error = sPSActionDescriptor->PutEnumerated(desc00000030, keyPalette, typeColorPalette, enumSelective);
	if (error) goto returnError;

	error = sPSActionDescriptor->PutInteger(desc00000030, keyColors, 16);
	if (error) goto returnError;

	error = sPSActionDescriptor->PutEnumerated(desc00000030, keyForcedColors, typeForcedColors, enumNone);
	if (error) goto returnError;

	error = sPSActionDescriptor->PutBoolean(desc00000030, keyTransparency, true);
	if (error) goto returnError;

	error = sPSActionDescriptor->PutObject(desc00000028, keyTo, classIndexedColorMode, desc00000030);
	if (error) goto returnError;

	error = sPSActionDescriptor->Make(&desc00000038);
	if (error) goto returnError;

	error = sPSActionDescriptor->PutBoolean(desc00000038, 'fooB', false);
	if (error) goto returnError;

	error = sPSActionControl->StringIDToTypeID("Neversoft NxPNG", &runtimeObjID);
	if (error) goto returnError;

	error = sPSActionDescriptor->PutObject(desc00000028, keyAs, runtimeObjID, desc00000038);
	if (error) goto returnError;

	error = sPSActionControl->Play(&result, eventOpen, desc00000028, plugInDialogSilent);
	if (error) goto returnError;

returnError:
     if (result != NULL) sPSActionDescriptor->Free(result);
     if (desc00000028 != NULL) sPSActionDescriptor->Free(desc00000028);
     if (aliasValue != NULL) sPSHandle->Dispose(aliasValue);
     if (desc00000030 != NULL) sPSActionDescriptor->Free(desc00000030);
     if (desc00000038 != NULL) sPSActionDescriptor->Free(desc00000038);
     return error;
}

SPErr PlayeventConvertMode(bool show_dialogs)
{
	PIActionDescriptor desc00000040 = NULL;
	PIActionDescriptor desc00000048 = NULL;
	PIActionDescriptor result = NULL;
	SPErr error = kSPNoError;

	error = sPSActionDescriptor->Make(&desc00000040);
	if (error) goto returnError;

	error = sPSActionDescriptor->Make(&desc00000048);
	if (error) goto returnError;

	if( show_dialogs )
	{
		error = sPSActionDescriptor->PutEnumerated(desc00000048, keyPalette, typeColorPalette, enumPerceptual);
		if (error) goto returnError;
		
		error = sPSActionDescriptor->PutInteger(desc00000048, keyColors, 16);
		if (error) goto returnError;
	}
	else
	{
		error = sPSActionDescriptor->PutEnumerated(desc00000048, keyPalette, typeColorPalette, enumPrevious);
			if (error) goto returnError;
	}
	
	error = sPSActionDescriptor->PutObject(desc00000040, keyTo, classIndexedColorMode, desc00000048);
	if (error) goto returnError;

	if( show_dialogs )
	{
		error = sPSActionControl->Play(&result, eventConvertMode, desc00000040, plugInDialogDisplay );
		if (error) goto returnError;
	}
	else
	{
		error = sPSActionControl->Play(&result, eventConvertMode, desc00000040, plugInDialogDontDisplay );
		if (error) goto returnError;
	}

returnError:
	if (result != NULL) sPSActionDescriptor->Free(result);
	if (desc00000040 != NULL) sPSActionDescriptor->Free(desc00000040);
	if (desc00000048 != NULL) sPSActionDescriptor->Free(desc00000048);
	return error;
}

SPErr PlayeventZoom(void)
{
	PIActionReference ref00000030 = NULL;
	PIActionDescriptor desc00000038 = NULL;
	PIActionDescriptor result = NULL;
	SPErr error = kSPNoError;     

	error = sPSActionDescriptor->Make(&desc00000038);
	if (error) goto returnError;

	error = sPSActionReference->Make(&ref00000030);
	if (error) goto returnError;

	error = sPSActionReference->PutName(ref00000030, classAction, "NxZoom");
	if (error) goto returnError;

	/*error = sPSActionReference->PutName(ref00000030, classActionSet, "Commands");
	if (error) goto returnError;*/

	error = sPSActionDescriptor->PutReference(desc00000038, keyNull, ref00000030);
	if (error) goto returnError;

	// Zoom once
	error = sPSActionControl->Play(&result, eventPlay, desc00000038, plugInDialogSilent);
	if (error) goto returnError;

returnError:
     if (result != NULL) sPSActionDescriptor->Free(result);
     if (desc00000038 != NULL) sPSActionDescriptor->Free(desc00000038);
     if (ref00000030 != NULL) sPSActionReference->Free(ref00000030);
     return error;
}

SPErr PlayeventConvertModeOld(bool show_dialogs)
{
    PIActionDescriptor desc00000040 = NULL;
	PIActionDescriptor desc00000048 = NULL;

	PIActionDescriptor result = NULL;
	SPErr error = kSPNoError;

	error = sPSActionDescriptor->Make(&desc00000040);
	if (error) goto returnError;

	error = sPSActionDescriptor->Make(&desc00000048);
	if (error) goto returnError;

	if( show_dialogs == false )
	{
		error = sPSActionDescriptor->PutEnumerated(desc00000048, keyPalette, typeColorPalette, enumPerceptual);
		if (error) goto returnError;

		error = sPSActionDescriptor->PutObject(desc00000040, keyTo, classIndexedColorMode, desc00000048);
		if (error) goto returnError;

		error = sPSActionControl->Play(&result, eventConvertMode, desc00000040, plugInDialogSilent );//plugInDialogDontDisplay );
		if (error) goto returnError;

		return 0;
	}

	

	error = sPSActionDescriptor->PutEnumerated(desc00000048, keyPalette, typeColorPalette, enumPerceptual);
	if (error) goto returnError;

	/*error = sPSActionDescriptor->PutInteger(desc00000048, keyColors, 16);
	if (error) goto returnError;*/

	/*error = sPSActionDescriptor->PutEnumerated(desc00000048, keyForcedColors, typeForcedColors, enumNone);
	if (error) goto returnError;

	error = sPSActionDescriptor->PutBoolean(desc00000048, keyTransparency, transparency);
	if (error) goto returnError;*/

	error = sPSActionDescriptor->PutObject(desc00000040, keyTo, classIndexedColorMode, desc00000048);
	if (error) goto returnError;

	if( show_dialogs )
	{
		error = sPSActionControl->Play(&result, eventConvertMode, desc00000040, plugInDialogDisplay);
		if (error) goto returnError;
	}
	else
	{
		error = sPSActionControl->Play(&result, eventConvertMode, desc00000040, plugInDialogDontDisplay );
		if (error) goto returnError;
	}

returnError:
	if (result != NULL) sPSActionDescriptor->Free(result);
	if (desc00000040 != NULL) sPSActionDescriptor->Free(desc00000040);
	if (desc00000048 != NULL) sPSActionDescriptor->Free(desc00000048);
	return error;
}

void EnsureFileAccess( char* path )
{
	int process_result;
	DWORD attribs;

	attribs = GetFileAttributes( path );
	if( attribs != -1 )
	{				
		if( attribs & FILE_ATTRIBUTE_READONLY )
		{
			char *args[4];

			args[0] = "p4";
			args[1] = "edit";
			args[2] = path;
			args[3] = NULL;
			process_result = spawnvp( _P_WAIT, args[0], args );
			if( process_result == -1 )
			{				
			}			
		}

		attribs = GetFileAttributes( path );
		if( attribs & FILE_ATTRIBUTE_READONLY )
		{
			SetFileAttributes( path, FILE_ATTRIBUTE_NORMAL );
		}
	}	
}

SPErr PlayeventSave( char* file_path, bool show_dialogs )
{
	PIActionDescriptor desc00000050 = NULL;
	PIActionDescriptor desc00000058 = NULL;
	Handle aliasValue = NULL;

	PIActionDescriptor result = NULL;
	DescriptorTypeID runtimeObjID;
	SPErr error = kSPNoError;
     

	error = sPSActionDescriptor->Make(&desc00000050);
	if (error) goto returnError;

	error = sPSActionDescriptor->Make(&desc00000058);
	if (error) goto returnError;

	error = sPSActionDescriptor->PutBoolean(desc00000058, 'barF', true);
	if (error) goto returnError;

	error = sPSActionControl->StringIDToTypeID("Neversoft NxPNG", &runtimeObjID);
	if (error) goto returnError;

	error = sPSActionDescriptor->PutObject(desc00000050, keyAs, runtimeObjID, desc00000058);
	if (error) goto returnError;

	if( show_dialogs )
	{
		SPPlatformFileSpecification startingDir;
		SPPlatformFileSpecification result;
		
		_splitpath( file_path, NULL, startingDir.path, NULL, NULL );
		ASBoolean success = sADMBasic->StandardPutFileDialog("Save As",
															 &startingDir,
															 file_path,
															 &result);
			
		if (success)
		{
			DWORD attribs;

			EnsureFileAccess( result.path );			

			attribs = GetFileAttributes( result.path );
			if( attribs != -1 )
			{				
				if( attribs & FILE_ATTRIBUTE_READONLY )
				{
					sADMBasic->ErrorAlert("Error: This file is either read-only or checked out by someone else and cannot be written to.");
					error = userCanceledErr;
					goto returnError;
				}
			}

			FullPathToAlias( result.path, aliasValue );
			error = sPSActionDescriptor->PutAlias(desc00000050, keyIn, aliasValue);
			if (error) goto returnError;	
		}
		else
		{
			error = userCanceledErr;
			goto returnError;
		}		
	}
	else
	{	
		FullPathToAlias( file_path, aliasValue);
		error = sPSActionDescriptor->PutAlias(desc00000050, keyIn, aliasValue);
		if (error) goto returnError;
	}

	error = sPSActionControl->Play(&result, eventSave, desc00000050, plugInDialogSilent);
	if (error) goto returnError;

returnError:
     if (result != NULL) sPSActionDescriptor->Free(result);
     if (desc00000050 != NULL) sPSActionDescriptor->Free(desc00000050);
     if (desc00000058 != NULL) sPSActionDescriptor->Free(desc00000058);
     if (aliasValue != NULL) sPSHandle->Dispose(aliasValue);
     return error;
}

SPErr PlayeventClose(void)
{
	PIActionDescriptor desc00000040 = NULL; 
	PIActionDescriptor result = NULL;
	SPErr error = kSPNoError;

	error = sPSActionDescriptor->Make(&desc00000040);
	if (error) goto returnError;

	error = sPSActionDescriptor->PutEnumerated(desc00000040, keySaving, typeYesNo, enumNo);
	if (error) goto returnError;

	error = sPSActionControl->Play(&result, eventClose, desc00000040, plugInDialogSilent);
	if (error) goto returnError;

returnError:
	if (result != NULL) sPSActionDescriptor->Free(result);
	if (desc00000040 != NULL) sPSActionDescriptor->Free(desc00000040);
	return error;
}

SPErr PlayeventImageSize(int width, int height, bool constrain_proportions, bool show_dialogs )
{
	PIActionDescriptor desc00000020 = NULL;
	PIActionDescriptor result = NULL;
	SPErr error = kSPNoError;

	error = sPSActionDescriptor->Make(&desc00000020);
	if (error) goto returnError;

	if(( width > 0 ) && ( height > 0 ))
	{
		error = sPSActionDescriptor->PutUnitFloat(desc00000020, keyWidth, unitPixels, width);
		if (error) goto returnError;

		error = sPSActionDescriptor->PutUnitFloat(desc00000020, keyHeight, unitPixels, height);
		if (error) goto returnError;		
	}
		
	error = sPSActionDescriptor->PutBoolean(desc00000020, keyConstrainProportions, constrain_proportions);
	if (error) goto returnError;
	
	error = sPSActionDescriptor->PutEnumerated(desc00000020, keyInterfaceIconFrameDimmed, typeInterpolation, enumBicubic);
	if (error) goto returnError;

	if( show_dialogs )
	{
		error = sPSActionControl->Play(&result, eventImageSize, desc00000020, plugInDialogDisplay);		
	}
	else
	{
		error = sPSActionControl->Play(&result, eventImageSize, desc00000020, plugInDialogSilent);		
	}
	if (error) goto returnError;

returnError:
	if (result != NULL) sPSActionDescriptor->Free(result);
	if (desc00000020 != NULL) sPSActionDescriptor->Free(desc00000020);
	return error;
}


SPErr PlayeventDuplicate( void )
{
	PIActionDescriptor desc00000028 = NULL;
	PIActionReference ref00000008 = NULL;
	PIActionDescriptor result = NULL;
	SPErr error = kSPNoError;

	error = sPSActionDescriptor->Make(&desc00000028);
	if (error) goto returnError;

	error = sPSActionReference->Make(&ref00000008);
	if (error) goto returnError;

	error = sPSActionReference->PutEnumerated(ref00000008, classDocument, typeOrdinal, enumFirst);
	if (error) goto returnError;

	error = sPSActionDescriptor->PutReference(desc00000028, keyNull, ref00000008);
	if (error) goto returnError;

	error = sPSActionControl->Play(&result, eventDuplicate, desc00000028, plugInDialogSilent);
	if (error) goto returnError;

returnError:
	if (result != NULL) sPSActionDescriptor->Free(result);
	if (desc00000028 != NULL) sPSActionDescriptor->Free(desc00000028);
	if (ref00000008 != NULL) sPSActionReference->Free(ref00000008);
	return error;
}

//-------------------------------------------------------------------------------
//
//	AutoNxPNGPlugin::AutoNxPNGPlugin
//
//	Derived class constructor. Make sure you initialize the base class.
//
//-------------------------------------------------------------------------------
AutoNxPNGPlugin::AutoNxPNGPlugin(SPPluginRef pluginRef) : AutomationPlugin(pluginRef)
{
}


//-------------------------------------------------------------------------------
//
//	AutoNxPNGPlugin::UnloadPlugin
//
//	Your about to get unloaded from memory. Delete anything dynamically created.
//
//-------------------------------------------------------------------------------
ASErr AutoNxPNGPlugin::UnloadPlugin(SPInterfaceMessage *message)
{
	return (AutomationPlugin::UnloadPlugin(message));
}


//-------------------------------------------------------------------------------
//
//	AutoNxPNGPlugin::~AutoNxPNGPlugin
//
//	Derived class destructor. Nothing to do for this class.
//  You should probably do clean up and memory overhead removal
//  during the UnloadPlugin call
//
//-------------------------------------------------------------------------------
AutoNxPNGPlugin::~AutoNxPNGPlugin()
{
}



//-------------------------------------------------------------------------------
//
//	AllocatePlugin
//	
//	The real constructor hear. You have to have one of these so the 
//	AutomationMain.cpp PluginMain routine can create your class.
//
//-------------------------------------------------------------------------------
AutomationPlugin *AllocatePlugin(SPPluginRef pluginRef)
{
	return new AutoNxPNGPlugin(pluginRef);
}


void	convert_to_forward_slashes( char* str )
{
	char* ptr;

	ptr = str;
	while( *ptr )
	{
		if( *ptr == '\\' )
		{
			*ptr = '/';
		}
		ptr++;
	}
}

//-------------------------------------------------------------------------------
//
//	AutoNxPNGPlugin::DoIt
//
//	Entry point for our plugin's work.
//
//-------------------------------------------------------------------------------
SPErr AutoNxPNGPlugin::DoIt(PSActionsPlugInMessage * message)
{
	SPErr error = kSPNoError;
	SPMessageData *basicMessage = NULL;
	bool show_dialogs = false ;
	bool same_file = true;

	if( message->actionParameters->playInfo == plugInDialogDisplay )
	{
		show_dialogs = true ;
	}
	
	// all messages contain a SPMessageData*
	basicMessage = (SPMessageData *) &message->d;
	sSPBasic = basicMessage->basic;

	// Photoshop is calling
	//if (sSPBasic->IsEqual((char*)caller, kPSPhotoshopCaller))
	{
		// the one and only message 
		//if (sSPBasic->IsEqual((char*)selector, kPSDoIt))
		{
			int width, height, original_width, original_height;
			double d_width, d_height, resolution;
			DescriptorUnitID out_width;
			int32 currentDocumentID = 0;
			int32 numDocuments = 0;

			// we are ignoring errors so this will not give an invalid error
			// message when there are no documents open
			PIUGetInfo(classApplication, keyNumberOfDocuments, &numDocuments, NULL);
			PIUGetInfo(classDocument, keyDocumentID, &currentDocumentID, NULL);
			error = PIUGetInfoByID(currentDocumentID, classDocument, keyResolution, &resolution, &out_width );
			if (error) goto returnError;
			error = PIUGetInfoByID(currentDocumentID, classDocument, keyWidth, &d_width, &out_width );
			if (error) goto returnError;
			error = PIUGetInfoByID(currentDocumentID, classDocument, keyHeight, &d_height, &out_width );
			if (error) goto returnError;
			original_width = UnitsToPixels( d_width, unitDistance, resolution );				
			if (error) goto returnError;
			original_height = UnitsToPixels( d_height, unitDistance, resolution );				
			if (error) goto returnError;

			if (numDocuments > 0)
			{
				char src_file_path[_MAX_PATH], file_path[_MAX_PATH],
						last_src_path[_MAX_PATH], last_dst_path[_MAX_PATH];
				char tmp_file[_MAX_PATH];
				char drive[_MAX_DRIVE];
				char path[_MAX_PATH];
				char filename[_MAX_FNAME];
				char ext[_MAX_EXT];
				Handle file_ref;
				char* user_name;
				char* path_ptr;
				bool is_johnny, constrain_proportions;
				DWORD rc, type;      
				HKEY key;
				DWORD disposition;
				LONG length;
				
				
				rc = RegCreateKeyEx(	HKEY_CURRENT_USER,                // handle to an open key
										"NxPNG",         // address of subkey name
										0,           // reserved
										NULL, //LPTSTR lpClass,           // address of class string
										REG_OPTION_NON_VOLATILE,          // special options flag
										KEY_ALL_ACCESS,        // desired security access
										NULL,                  // address of key security structure
										&key,          // address of buffer for opened handle
										&disposition );   // address of disposition value buffer

				user_name = getenv( "USERNAME" );
				if( stricmp( user_name, "johnny" ) == 0 )
				{
					is_johnny = true;
				}
				else
				{
					is_johnny = false;
				}

				error = PIUGetInfoByID(currentDocumentID, classDocument, keyFileReference, &file_ref, 0);
				if (error) goto returnError;
				
				AliasToFullPath( file_ref, src_file_path );				
				strcpy( file_path, src_file_path );				
				
				_splitpath( file_path, NULL, NULL, NULL, ext );
				if( stricmp( ext, ".psd" ))
				{
					ADMAnswer answer;

					answer = sADMBasic->QuestionAlert( "Your source image is not a PSD. Are you sure you would like to convert this image?" );
					if( answer != kADMYesAnswer )
					{
						return 0;
					}				
				}

				length = _MAX_PATH;
				type = REG_SZ;
				rc = RegQueryValueEx( key, "LastSource", 0,	&type, (PBYTE) last_src_path, (PDWORD) &length );
				length = _MAX_PATH;
				rc = RegQueryValueEx( key, "LastDest", 0, &type, (PBYTE) last_dst_path, (PDWORD) &length );				

				if( stricmp( last_src_path, src_file_path ))
				{
					show_dialogs = true;
					same_file = false;
				}

				error = PlayeventDuplicate();
				if (error) goto returnError;

				length = 4;
				width = 0;
				height = 0;
				constrain_proportions = true;
				// Only use the previous "Width" value if we're working with the same source file
				if( same_file )
				{
					rc = RegQueryValueEx( key, "LastWidth", 0, &type, (PBYTE) &width, (PDWORD) &length );
					rc = RegQueryValueEx( key, "LastHeight", 0, &type, (PBYTE) &height, (PDWORD) &length );					
					rc = RegQueryValueEx( key, "ConstrainProportions", 0, &type, (PBYTE) &constrain_proportions, (PDWORD) &length );					
					
				}				

				error = PlayeventImageSize( width, height, constrain_proportions, show_dialogs );
				if (error)
				{
					PlayeventClose();
					goto returnError;
				}				

				if( stricmp( last_src_path, src_file_path ) == 0 )
				{
					strcpy( file_path, last_dst_path );
					_splitpath( file_path, drive, path, filename, NULL );
					sprintf( tmp_file, "%s%snx_tmp.png", drive, path );
				}
				else
				{
					_splitpath( file_path, drive, path, filename, NULL );
					if( path[0] == '\0' )
					{
						PlayeventClose();
						sADMBasic->ErrorAlert("Error: This exporter will not work on an unnamed document. You must first save your document.");						
						return 0;
					}

					path_ptr = strstr( path, "\\PSD\\" );
					if( path_ptr == NULL )
					{
						path_ptr = strstr( path, "\\psd\\" );
						if( path_ptr == NULL )
						{
							path_ptr = strstr( path, "\\Psd\\" );
						}
					}
					if( path_ptr )
					{
						path_ptr[1] = '\0';
					}
					sprintf( file_path, "%s%s%s.png", drive, path, filename );
					sprintf( tmp_file, "%s%snx_tmp.png", drive, path );
				}				

				if( !is_johnny )
				{
					EnsureFileAccess( file_path );

					CopyFile( file_path, tmp_file, false );
					//DeleteFile( file_path );

					error = PlayeventSaveAs( file_path );
					if (error)
					{						
						DeleteFile( file_path );
						CopyFile( tmp_file, file_path, false );
						DeleteFile( tmp_file );
						
						// Couldn't save the file as a PNG. Potentially because it wasn't in RGB?
						//pop an error dialog
						sADMBasic->ErrorAlert("Error: Your image could not be saved as a PNG.  Ensure that it is in RGB color mode and that the destination file is not read-only.");						
						return 0;
						//goto returnError;
					}

					error = PlayeventClose();
					if (error)
					{
						DeleteFile( file_path );
						CopyFile( tmp_file, file_path, false );
						DeleteFile( tmp_file );
						goto returnError;
					}

					error = PlayeventOpen( file_path );
					if (error)
					{
						DeleteFile( file_path );
						CopyFile( tmp_file, file_path, false );
						DeleteFile( tmp_file );
						goto returnError;
					}				

					DeleteFile( file_path );
					CopyFile( tmp_file, file_path, false );
					DeleteFile( tmp_file );
				}

				PlayeventZoom();
				
				error = PlayeventConvertMode( show_dialogs );
				if (error)
				{
					PlayeventClose();
					goto returnError;
				}

				sprintf( file_path, "%s%s%s.png", drive, path, filename );
				error = PlayeventSave( file_path, show_dialogs );
				if (error)
				{
					PlayeventClose();
					goto returnError;
				}

				// Get the width and the new filename that the user chose				
				PIUGetInfo(classDocument, keyDocumentID, &currentDocumentID, NULL);
				error = PIUGetInfoByID(currentDocumentID, classDocument, keyResolution, &resolution, &out_width );
				if (error) goto returnError;
				error = PIUGetInfoByID(currentDocumentID, classDocument, keyWidth, &d_width, &out_width );
				if (error) goto returnError;
				error = PIUGetInfoByID(currentDocumentID, classDocument, keyHeight, &d_height, &out_width );
				if (error) goto returnError;
				width = UnitsToPixels( d_width, unitDistance, resolution );				
				if (error) goto returnError;
				height = UnitsToPixels( d_height, unitDistance, resolution );				
				if (error) goto returnError;
				error = PIUGetInfoByID(currentDocumentID, classDocument, keyFileReference, &file_ref, 0);
				if (error) goto returnError;

				AliasToFullPath( file_ref, file_path );				

				error = PlayeventClose();
				if (error) goto returnError;				


				// At this point, the image has been successfully exported.
				// If it was an image destined for %PROJ_ROOT%/data/images/...
				// then convert it for use in the game
				char* proj_root;
				char search_str[_MAX_PATH];
				char out_path[_MAX_PATH];
				
				proj_root = getenv( "PROJ_ROOT" );
				if( proj_root )
				{
					sprintf( search_str, "%s\\data\\images", proj_root );
					convert_to_forward_slashes( search_str );
					strcpy( out_path, file_path );
					convert_to_forward_slashes( out_path );
					if( strstr( strlwr( out_path ), strlwr( search_str )))
					{
						char *args[3];
						char cmd_line[_MAX_PATH];

						sprintf( cmd_line, "%s\\bin\\win32\\convertassets.exe", proj_root );

						args[0] = cmd_line;
						args[1] = "-pp";
						args[2] = NULL;
						spawnvp( _P_WAIT, args[0], args );					
					}
				}
				
				if(	((float) original_width / (float) original_height) ==
						((float) width / (float) height ))
				{
					constrain_proportions = true;
				}
				else
				{
					constrain_proportions = false;
				}
				rc = RegSetValueEx( key, "LastSource", 0, REG_SZ,
										(const BYTE*) src_file_path, strlen(src_file_path)+1 ); 
				rc = RegSetValueEx( key, "LastDest", 0, REG_SZ,
										(const BYTE*) file_path, strlen(file_path)+1 ); 				
				rc = RegSetValueEx( key, "LastWidth", 0, REG_DWORD,
										(const BYTE*) &width, 4 );
				rc = RegSetValueEx( key, "LastHeight", 0, REG_DWORD,
										(const BYTE*) &height, 4 );
				rc = RegSetValueEx( key, "ConstrainProportions", 0, REG_DWORD,
										(const BYTE*) &constrain_proportions, 4 );
				
				rc = RegCloseKey( key );

				if( is_johnny )
				{
					FILE* file;
					file = fopen( "c:\\JOW\\JOW_PSLastSave.txt", "w" );
					fprintf( file, file_path );
					fclose( file );
				}
			}
		}
	}

returnError:	
	
	return error;
}
// end of NxPNG Auto.cpp
